<?php
require_once __DIR__ . '/../../config/Config.php';
require_once __DIR__ . '/../../config/Database.php';

session_start();

// Redirect to login if not authenticated
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit;
}
/*
// Check session timeout
$timeout = Config::get('SESSION_TIMEOUT', 3600);
if (isset($_SESSION['admin_last_activity']) && (time() - $_SESSION['admin_last_activity'] > $timeout)) {
    session_unset();
    session_destroy();
    header('Location: login.php?timeout=1');
    exit;
}
*/
// Update last activity time
$_SESSION['admin_last_activity'] = time();

// CSRF token generation and validation
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

function verifyCsrfToken() {
    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        die('Invalid CSRF token');
    }
}

// Database connection
$db = Database::getInstance()->getConnection();

// Log admin activity
/**
 * Mencatat aktivitas admin
 * 
 * @param int $adminId ID admin
 * @param string $action Aksi yang dilakukan (e.g., "LOGIN", "UPDATE_SETTINGS")
 * @param array|null $data Data tambahan dalam bentuk array
 */
function logAdminActivity($adminId, $action, $data = null) {
    $db = Database::getInstance()->getConnection();
    
    try {
        $stmt = $db->prepare("
            INSERT INTO admin_activities 
            (admin_id, username, ip_address, user_agent, action, details, created_at)
            VALUES (:admin_id, :username, :ip, :ua, :action, :details, NOW())
        ");
        
        $stmt->execute([
            ':admin_id' => $adminId,
            ':username' => $_SESSION['admin_username'],
            ':ip' => $_SERVER['REMOTE_ADDR'],
            ':ua' => $_SERVER['HTTP_USER_AGENT'],
            ':action' => $action,
            ':details' => $data ? json_encode($data, JSON_UNESCAPED_UNICODE) : null
        ]);
        
        return true;
    } catch (PDOException $e) {
        error_log("Gagal mencatat aktivitas admin: " . $e->getMessage());
        return false;
    }
}

// Check if current request should be logged
$loggableActions = ['POST', 'PUT', 'DELETE'];
if (in_array($_SERVER['REQUEST_METHOD'], $loggableActions)) {
    $action = $_SERVER['REQUEST_METHOD'] . ' ' . basename($_SERVER['PHP_SELF']);
    $details = json_encode($_REQUEST);
    logAdminActivity($action, $details);
}