<?php
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/../config/Database.php';

$db = Database::getInstance()->getConnection();

// Get statistics based on period
$period = $_GET['period'] ?? 'week';
$validPeriods = ['day', 'week', 'month'];
$period = in_array($period, $validPeriods) ? $period : 'week';

// Get user growth stats
$userGrowth = $db->query("
    SELECT 
        DATE(join_date) as date,
        COUNT(*) as new_users,
        (SELECT COUNT(*) FROM users WHERE DATE(join_date) <= date) as total_users
    FROM users
    WHERE join_date > DATE_SUB(NOW(), INTERVAL 30 DAY)
    GROUP BY DATE(join_date)
    ORDER BY date ASC
")->fetchAll();

// Get message stats
$messageStats = $db->query("
    SELECT 
        DATE(created_at) as date,
        COUNT(*) as message_count,
        SUM(CASE WHEN direction = 'incoming' THEN 1 ELSE 0 END) as incoming,
        SUM(CASE WHEN direction = 'outgoing' THEN 1 ELSE 0 END) as outgoing
    FROM messages
    WHERE created_at > DATE_SUB(NOW(), INTERVAL 30 DAY)
    GROUP BY DATE(created_at)
    ORDER BY date ASC
")->fetchAll();

// Get active users
$activeUsers = $db->query("
    SELECT 
        DATE(last_activity) as date,
        COUNT(DISTINCT user_id) as active_users
    FROM users
    WHERE last_activity > DATE_SUB(NOW(), INTERVAL 30 DAY)
    GROUP BY DATE(last_activity)
    ORDER BY date ASC
")->fetchAll();

// Get message types
$messageTypes = $db->query("
    SELECT 
        message_type,
        COUNT(*) as count
    FROM messages
    WHERE created_at > DATE_SUB(NOW(), INTERVAL 30 DAY)
    GROUP BY message_type
    ORDER BY count DESC
")->fetchAll();

// Prepare data for charts
$labels = [];
$newUsersData = [];
$totalUsersData = [];
$incomingMessages = [];
$outgoingMessages = [];
$activeUsersData = [];

foreach ($userGrowth as $stat) {
    $labels[] = date('d M', strtotime($stat['date']));
    $newUsersData[] = $stat['new_users'];
    $totalUsersData[] = $stat['total_users'];
}

foreach ($messageStats as $stat) {
    $incomingMessages[] = $stat['incoming'];
    $outgoingMessages[] = $stat['outgoing'];
}

foreach ($activeUsers as $stat) {
    $activeUsersData[] = $stat['active_users'];
}

require_once __DIR__ . '/includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <?php require_once __DIR__ . '/includes/sidebar.php'; ?>
        
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Statistik</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <a href="?period=day" class="btn btn-sm btn-outline-secondary <?= $period === 'day' ? 'active' : '' ?>">Harian</a>
                        <a href="?period=week" class="btn btn-sm btn-outline-secondary <?= $period === 'week' ? 'active' : '' ?>">Mingguan</a>
                        <a href="?period=month" class="btn btn-sm btn-outline-secondary <?= $period === 'month' ? 'active' : '' ?>">Bulanan</a>
                    </div>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5>Pertumbuhan Pengguna</h5>
                        </div>
                        <div class="card-body">
                            <canvas id="userGrowthChart" height="250"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5>Aktivitas Pesan</h5>
                        </div>
                        <div class="card-body">
                            <canvas id="messageActivityChart" height="250"></canvas>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5>Pengguna Aktif</h5>
                        </div>
                        <div class="card-body">
                            <canvas id="activeUsersChart" height="250"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5>Jenis Pesan</h5>
                        </div>
                        <div class="card-body">
                            <canvas id="messageTypesChart" height="250"></canvas>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h5>Data Statistik</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Tanggal</th>
                                    <th>Pengguna Baru</th>
                                    <th>Total Pengguna</th>
                                    <th>Pesan Masuk</th>
                                    <th>Pesan Keluar</th>
                                    <th>Pengguna Aktif</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php for ($i = 0; $i < count($labels); $i++): ?>
                                    <tr>
                                        <td><?= $labels[$i] ?></td>
                                        <td><?= $newUsersData[$i] ?? 0 ?></td>
                                        <td><?= $totalUsersData[$i] ?? 0 ?></td>
                                        <td><?= $incomingMessages[$i] ?? 0 ?></td>
                                        <td><?= $outgoingMessages[$i] ?? 0 ?></td>
                                        <td><?= $activeUsersData[$i] ?? 0 ?></td>
                                    </tr>
                                <?php endfor; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<script>
    // User Growth Chart
    const userGrowthCtx = document.getElementById('userGrowthChart').getContext('2d');
    const userGrowthChart = new Chart(userGrowthCtx, {
        type: 'line',
        data: {
            labels: <?= json_encode($labels) ?>,
            datasets: [
                {
                    label: 'Pengguna Baru',
                    data: <?= json_encode($newUsersData) ?>,
                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 2,
                    tension: 0.1
                },
                {
                    label: 'Total Pengguna',
                    data: <?= json_encode($totalUsersData) ?>,
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 2,
                    tension: 0.1
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
    
    // Message Activity Chart
    const messageActivityCtx = document.getElementById('messageActivityChart').getContext('2d');
    const messageActivityChart = new Chart(messageActivityCtx, {
        type: 'bar',
        data: {
            labels: <?= json_encode($labels) ?>,
            datasets: [
                {
                    label: 'Pesan Masuk',
                    data: <?= json_encode($incomingMessages) ?>,
                    backgroundColor: 'rgba(255, 99, 132, 0.7)',
                },
                {
                    label: 'Pesan Keluar',
                    data: <?= json_encode($outgoingMessages) ?>,
                    backgroundColor: 'rgba(54, 162, 235, 0.7)',
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
    
    // Active Users Chart
    const activeUsersCtx = document.getElementById('activeUsersChart').getContext('2d');
    const activeUsersChart = new Chart(activeUsersCtx, {
        type: 'line',
        data: {
            labels: <?= json_encode($labels) ?>,
            datasets: [
                {
                    label: 'Pengguna Aktif',
                    data: <?= json_encode($activeUsersData) ?>,
                    backgroundColor: 'rgba(153, 102, 255, 0.2)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 2,
                    tension: 0.1
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
    
    // Message Types Chart
    const messageTypesCtx = document.getElementById('messageTypesChart').getContext('2d');
    const messageTypesChart = new Chart(messageTypesCtx, {
        type: 'doughnut',
        data: {
            labels: <?= json_encode(array_column($messageTypes, 'message_type')) ?>,
            datasets: [{
                data: <?= json_encode(array_column($messageTypes, 'count')) ?>,
                backgroundColor: [
                    'rgba(255, 99, 132, 0.7)',
                    'rgba(54, 162, 235, 0.7)',
                    'rgba(255, 206, 86, 0.7)',
                    'rgba(75, 192, 192, 0.7)',
                    'rgba(153, 102, 255, 0.7)',
                    'rgba(255, 159, 64, 0.7)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'right',
                }
            }
        }
    });
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>