<?php
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/../config/Database.php';

session_start();

$db = Database::getInstance()->getConnection();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verifyCsrfToken();
    
    if (isset($_POST['action']) && $_POST['action'] === 'delete_user' && isset($_POST['user_id'])) {
        $userId = (int)$_POST['user_id'];
        
        $stmt = $db->prepare("DELETE FROM users WHERE user_id = :user_id");
        $stmt->execute([':user_id' => $userId]);
        
        $_SESSION['flash_message'] = "Pengguna berhasil dihapus";
        $_SESSION['flash_type'] = "success";
        header("Location: users.php");
        exit;
    }
}

// Get search parameters
$search = $_GET['search'] ?? '';
$page = max(1, $_GET['page'] ?? 1);
$perPage = 20;
$offset = ($page - 1) * $perPage;

// Build query
$query = "SELECT * FROM users";
$params = [];
$countQuery = "SELECT COUNT(*) as total FROM users";

if (!empty($search)) {
    $query .= " WHERE username LIKE :search OR first_name LIKE :search OR last_name LIKE :search";
    $countQuery .= " WHERE username LIKE :search OR first_name LIKE :search OR last_name LIKE :search";
    $params[':search'] = "%$search%";
}

// Add sorting
$sort = $_GET['sort'] ?? 'last_activity';
$order = $_GET['order'] ?? 'desc';
$validSorts = ['user_id', 'username', 'first_name', 'last_name', 'join_date', 'last_activity'];
$validOrders = ['asc', 'desc'];

if (!in_array($sort, $validSorts)) $sort = 'last_activity';
if (!in_array($order, $validOrders)) $order = 'desc';

$query .= " ORDER BY $sort $order LIMIT :offset, :per_page";

// Get users
$stmt = $db->prepare($query);
foreach ($params as $key => $value) {
    $stmt->bindValue($key, $value);
}
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':per_page', $perPage, PDO::PARAM_INT);
$stmt->execute();
$users = $stmt->fetchAll();

// Get total count
$stmt = $db->prepare($countQuery);
foreach ($params as $key => $value) {
    $stmt->bindValue($key, $value);
}
$stmt->execute();
$totalUsers = $stmt->fetch()['total'];
$totalPages = ceil($totalUsers / $perPage);

// Set page title
$pageTitle = "Manajemen Pengguna";

require_once __DIR__ . '/includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <?php require_once __DIR__ . '/includes/sidebar.php'; ?>
        
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Manajemen Pengguna</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <button type="button" class="btn btn-sm btn-outline-secondary">Export</button>
                    </div>
                </div>
            </div>
            
           
            
            <div class="card mb-4">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="mb-0">Daftar Pengguna</h5>
                        </div>
                        <div class="col-md-6">
                            <form method="get" class="float-end">
                                <div class="input-group">
                                    <input type="text" name="search" class="form-control form-control-sm" placeholder="Cari pengguna..." value="<?= htmlspecialchars($search) ?>">
                                    <button class="btn btn-sm btn-outline-secondary" type="submit">Cari</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm table-hover">
                            <thead>
                                <tr>
                                    <th>
                                        <a href="?search=<?= urlencode($search) ?>&sort=user_id&order=<?= $sort === 'user_id' && $order === 'asc' ? 'desc' : 'asc' ?>">
                                            ID <?= $sort === 'user_id' ? ($order === 'asc' ? '↑' : '↓') : '' ?>
                                        </a>
                                    </th>
                                    <th>Foto</th>
                                    <th>
                                        <a href="?search=<?= urlencode($search) ?>&sort=username&order=<?= $sort === 'username' && $order === 'asc' ? 'desc' : 'asc' ?>">
                                            Username <?= $sort === 'username' ? ($order === 'asc' ? '↑' : '↓') : '' ?>
                                        </a>
                                    </th>
                                    <th>
                                        <a href="?search=<?= urlencode($search) ?>&sort=first_name&order=<?= $sort === 'first_name' && $order === 'asc' ? 'desc' : 'asc' ?>">
                                            Nama <?= $sort === 'first_name' ? ($order === 'asc' ? '↑' : '↓') : '' ?>
                                        </a>
                                    </th>
                                    <th>
                                        <a href="?search=<?= urlencode($search) ?>&sort=join_date&order=<?= $sort === 'join_date' && $order === 'asc' ? 'desc' : 'asc' ?>">
                                            Bergabung <?= $sort === 'join_date' ? ($order === 'asc' ? '↑' : '↓') : '' ?>
                                        </a>
                                    </th>
                                    <th>
                                        <a href="?search=<?= urlencode($search) ?>&sort=last_activity&order=<?= $sort === 'last_activity' && $order === 'asc' ? 'desc' : 'asc' ?>">
                                            Terakhir Aktif <?= $sort === 'last_activity' ? ($order === 'asc' ? '↑' : '↓') : '' ?>
                                        </a>
                                    </th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($users as $user): ?>
                                    <tr>
                                        <td><?= $user['user_id'] ?></td>
                                        <td>
                                            <?php if ($user['photo_path']): ?>
                                                <img src="<?= htmlspecialchars($user['photo_path']) ?>" alt="Foto profil" width="30" height="30" class="rounded-circle">
                                            <?php else: ?>
                                                <div class="bg-secondary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                                    <?= substr($user['first_name'], 0, 1) ?>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($user['username']): ?>
                                                @<?= htmlspecialchars($user['username']) ?>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= htmlspecialchars($user['first_name'] . ' ' . $user['last_name']) ?></td>
                                        <td><?= date('d M Y', strtotime($user['join_date'])) ?></td>
                                        <td>
                                            <?php if ($user['last_activity']): ?>
                                                <?= date('d M Y H:i', strtotime($user['last_activity'])) ?>
                                            <?php else: ?>
                                                <span class="text-muted">Belum pernah</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <a href="user-detail.php?id=<?= $user['user_id'] ?>" class="btn btn-outline-primary" title="Detail">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <form method="post" class="d-inline">
                                                    <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
                                                    <input type="hidden" name="action" value="delete_user">
                                                    <input type="hidden" name="user_id" value="<?= $user['user_id'] ?>">
                                                    <button type="submit" class="btn btn-outline-danger" title="Hapus" onclick="return confirm('Apakah Anda yakin ingin menghapus pengguna ini?')">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <nav aria-label="Page navigation">
                        <ul class="pagination justify-content-center">
                            <?php if ($page > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?search=<?= urlencode($search) ?>&sort=<?= $sort ?>&order=<?= $order ?>&page=<?= $page - 1 ?>">
                                        Sebelumnya
                                    </a>
                                </li>
                            <?php endif; ?>
                            
                            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                                <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                                    <a class="page-link" href="?search=<?= urlencode($search) ?>&sort=<?= $sort ?>&order=<?= $order ?>&page=<?= $i ?>">
                                        <?= $i ?>
                                    </a>
                                </li>
                            <?php endfor; ?>
                            
                            <?php if ($page < $totalPages): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?search=<?= urlencode($search) ?>&sort=<?= $sort ?>&order=<?= $order ?>&page=<?= $page + 1 ?>">
                                        Selanjutnya
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                </div>
            </div>
        </main>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>