<?php
class Config {
    private static $config = [];
    
    public static function load() {
        $envFile = __DIR__ . '/../.env';
        if (file_exists($envFile)) {
            $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            foreach ($lines as $line) {
                if (strpos(trim($line), '#') === 0) continue;
                
                list($name, $value) = explode('=', $line, 2);
                self::$config[trim($name)] = trim($value);
            }
        }
    }
    
    public static function get($key, $default = null) {
        return self::$config[$key] ?? $default;
    }
    
    public static function set($key, $value) {
        self::$config[$key] = $value;
    }
    
    public static function save() {
        $envFile = __DIR__ . '/../.env';
        $lines = [];
        foreach (self::$config as $key => $value) {
            $lines[] = "$key=$value";
        }
        file_put_contents($envFile, implode(PHP_EOL, $lines));
    }
}

// Load config saat file diinclude
Config::load();