<?php
class CommandHandler {
    private $bot;
    private $db;
    
    public function __construct($bot, $db) {
        $this->bot = $bot;
        $this->db = $db;
    }
    
    public function handle($chatId, $userId, $command, $message) {
        switch ($command) {
            case 'start':
                $this->handleStart($chatId, $userId, $message);
                break;
                
            case 'help':
                $this->handleHelp($chatId);
                break;
                
            case 'menu':
                $this->handleMenu($chatId);
                break;
                
            case 'admin':
                $this->handleAdmin($chatId, $userId);
                break;
                
            case 'stats':
                $this->handleStats($chatId, $userId);
                break;
                
            default:
                $this->bot->sendMessage($chatId, "Perintah tidak dikenali. Ketik /help untuk melihat daftar perintah yang tersedia.");
        }
    }
    
    private function handleStart($chatId, $userId, $message) {
        $welcomeMessage = Config::get('BOT_WELCOME_MESSAGE', 'Halo! Selamat datang di bot kami.');
        
        // Check if there's a deep link parameter
        $deepLink = null;
        if (isset($message['text']) && strpos($message['text'], ' ') !== false) {
            $deepLink = trim(explode(' ', $message['text'], 2)[1]);
        }
        
        if ($deepLink) {
            // Handle deep link (e.g., referral codes, special commands)
            $welcomeMessage .= "\n\nAnda menggunakan link khusus: $deepLink";
        }
        
        $keyboard = [
            [['text' => '📋 Menu Utama', 'callback_data' => 'main_menu']],
            [['text' => '🆘 Bantuan', 'callback_data' => 'help']]
        ];
        
        $this->bot->sendMessage(
            $chatId, 
            $welcomeMessage, 
            $this->bot->buildInlineKeyboard($keyboard)
        );
    }
    
    private function handleHelp($chatId) {
        $helpText = "🤖 *Daftar Perintah Bot*\n\n" .
                    "/start - Memulai bot\n" .
                    "/help - Menampilkan pesan bantuan ini\n" .
                    "/menu - Menampilkan menu utama\n" .
                    "/admin - Menu admin (hanya untuk admin)\n\n" .
                    "Anda juga bisa menggunakan tombol di bawah untuk berinteraksi dengan bot.";
        
        $keyboard = [
            [['text' => '📋 Menu Utama', 'callback_data' => 'main_menu']],
            [['text' => 'ℹ️ Tentang Bot', 'callback_data' => 'about']]
        ];
        
        $this->bot->sendMessage(
            $chatId, 
            $helpText, 
            $this->bot->buildInlineKeyboard($keyboard)
        );
    }
    
    private function handleMenu($chatId) {
        $keyboard = [
            [['text' => '📊 Informasi', 'callback_data' => 'info']],
            [['text' => '📅 Jadwal', 'callback_data' => 'schedule']],
            [['text' => '📩 Hubungi Kami', 'callback_data' => 'contact']],
            [['text' => '⚙️ Pengaturan', 'callback_data' => 'settings']]
        ];
        
        $this->bot->sendMessage(
            $chatId,
            "📋 *Menu Utama*\nPilih opsi di bawah:",
            $this->bot->buildInlineKeyboard($keyboard)
        );
    }
    
    private function handleAdmin($chatId, $userId) {
        $adminIds = explode(',', Config::get('TELEGRAM_ADMIN_IDS'));
        
        if (!in_array($userId, $adminIds)) {
            $this->bot->sendMessage($chatId, "⛔ Anda tidak memiliki akses admin.");
            return;
        }
        
        $keyboard = [
            [['text' => '📊 Statistik', 'callback_data' => 'admin_stats']],
            [['text' => '📢 Broadcast', 'callback_data' => 'admin_broadcast']],
            [['text' => '⚙️ Pengaturan Bot', 'callback_data' => 'admin_settings']],
            [['text' => '📤 Posting ke Channel', 'callback_data' => 'admin_channel_post']]
        ];
        
        $this->bot->sendMessage(
            $chatId,
            "👨‍💻 *Menu Admin*\nPilih opsi di bawah:",
            $this->bot->buildInlineKeyboard($keyboard)
        );
    }
    
    private function handleStats($chatId, $userId) {
        $adminIds = explode(',', Config::get('TELEGRAM_ADMIN_IDS'));
        
        if (!in_array($userId, $adminIds)) {
            $this->bot->sendMessage($chatId, "⛔ Anda tidak memiliki akses ke statistik.");
            return;
        }
        
        // Get user count
        $stmt = $this->db->prepare("SELECT COUNT(*) as user_count FROM users");
        $stmt->execute();
        $userCount = $stmt->fetch()['user_count'];
        
        // Get message count
        $stmt = $this->db->prepare("
            SELECT 
                COUNT(*) as message_count,
                SUM(CASE WHEN direction = 'incoming' THEN 1 ELSE 0 END) as incoming,
                SUM(CASE WHEN direction = 'outgoing' THEN 1 ELSE 0 END) as outgoing
            FROM messages
        ");
        $stmt->execute();
        $messageStats = $stmt->fetch();
        
        $statsText = "📊 *Statistik Bot*\n\n" .
                    "👥 Total Pengguna: $userCount\n" .
                    "📨 Total Pesan:\n" .
                    "  - Masuk: {$messageStats['incoming']}\n" .
                    "  - Keluar: {$messageStats['outgoing']}\n" .
                    "  - Total: {$messageStats['message_count']}";
        
        $this->bot->sendMessage($chatId, $statsText);
    }
}