<?php
class ReplyKeyboard {
    public static function createMainMenu() {
        return [
            'keyboard' => [
                ['📋 Informasi Produk', '🛒 Belanja'],
                ['📞 Hubungi Kami', '⚙️ Pengaturan'],
                ['🆘 Bantuan']
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false,
            'selective' => true
        ];
    }
    
    public static function createProductCategories($categories) {
        $keyboard = [];
        $row = [];
        
        foreach ($categories as $index => $category) {
            $row[] = $category['name'];
            
            // Add 2 buttons per row
            if (($index + 1) % 2 === 0) {
                $keyboard[] = $row;
                $row = [];
            }
        }
        
        // Add remaining buttons
        if (!empty($row)) {
            $keyboard[] = $row;
        }
        
        // Add back button
        $keyboard[] = ['🔙 Kembali ke Menu'];
        
        return [
            'keyboard' => $keyboard,
            'resize_keyboard' => true,
            'one_time_keyboard' => false,
            'selective' => true
        ];
    }
    
    public static function createContactRequest() {
        return [
            'keyboard' => [
                [['text' => '📱 Kirim Nomor Telepon', 'request_contact' => true]],
                [['text' => '📍 Kirim Lokasi Saya', 'request_location' => true]],
                ['🔙 Kembali']
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => true
        ];
    }
    
    public static function createYesNo() {
        return [
            'keyboard' => [
                ['✅ Ya', '❌ Tidak']
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => true
        ];
    }
    
    public static function removeKeyboard() {
        return [
            'remove_keyboard' => true,
            'selective' => true
        ];
    }
    
    public static function createAdminPanel() {
        return [
            'keyboard' => [
                ['📊 Statistik', '📢 Broadcast'],
                ['👥 Manajemen User', '⚙️ Pengaturan Bot'],
                ['🔙 Keluar dari Admin']
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
    }
}